<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="AdminRegistryFlags" Codebehind="AdminRegistryFlags.aspx.cs" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    
   
    <div class="breadcrumb">
        <asp:Label ID = "BreadCrumbLabel" runat="server" Text="Administration > Registry Flags"/>
    </div>    
    
    <div class = "excludeSaveWarnings">
    <br />
    <asp:Panel ID="PanelRegistryFlags" runat="server" GroupingText="Manage Registry Flags&nbsp;&nbsp;" Width="100%">
            <table>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForTextBoxKeyWords" runat="server" Text="Filter By Key Words:"
                            AssociatedControlID="TextBoxKeyWords" ToolTip="Filter By Key Words" /> 
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDropDownListStatus" runat="server" Text="Filter By Status:"
                            AssociatedControlID="DropDownListStatus" ToolTip="Filter by Status" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                     </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelforDropDownListType" runat="server" Text="Filter By Flag Type:"
                            AssociatedControlID="DropDownListType" ToolTip="Filter by Type" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                    </td>
                 </tr>
                <tr>
                    <td>
                        <asp:TextBox ID="TextBoxKeyWords" runat="server" Width="300" ToolTip="Filter By Key Words"></asp:TextBox>  
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp                  
                    </td>
                    <td>
                         <asp:DropDownList runat='server' ID='DropDownListStatus' ToolTip='Filter by Status'>
                            <asp:ListItem Text='All' />
                            <asp:ListItem Text='Active' />
                            <asp:ListItem Text='Inactive' />
                        </asp:DropDownList>
                    </td>
                    <td>
                         <asp:DropDownList runat='server' ID='DropDownListType' ToolTip='Filter by Flag Type'>
                            <asp:ListItem Text='All' />
                            <asp:ListItem Text='Administrative Flag' />
                            <asp:ListItem Text='Subpopulation Flag' />
                        </asp:DropDownList>                    
                    </td>
                </tr>
                <tr><td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td></tr>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelforDropDownListPredefined" runat="server" Text="Filter By Predefined:"
                            AssociatedControlID="DropDownListPredefined" ToolTip="Filter by Predefined" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                         <asp:DropDownList runat='server' ID='DropDownListPredefined' ToolTip='Filter by Predefined'>
                            <asp:ListItem Text='All' />
                            <asp:ListItem Text='Yes' />
                            <asp:ListItem Text='No' />
                        </asp:DropDownList>                    
                    </td>
                    <td>
                        <asp:Button ID="ButtonSearch" runat="server" Text=" Filter " OnClick="ButtonSearch_Click" />                        
                    </td>
                    <td>
                        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
                    </td>
                </tr>
            </table>           

    <div style="text-align: right; width: 1100px;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true"  CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
    </div>
    <asp:GridView ID = "GridViewRegistryFlags" 
        DataSourceID="ObjectDataSourceRegistryFlags" 
        ShowFooter = "True"
        Width="1100px" 
        AutoGenerateColumns = "False" 
        runat ="server"   
        OnPreRender="GridViewRegistryFlags_PreRender"
        DataKeyNames = "STD_REGISTRY_FLAG_ID" 
        OnRowCommand="GridViewRegistryFlags_RowCommand" 
        Caption="To sort please click table headings" 
        AllowPaging="True"
        AllowSorting="True" EmptyDataText="No Registry Flags Available"
        PagerSettings-Mode="Numeric"
        OnPageIndexChanging="gridView_PageIndexChanging">
        <EmptyDataTemplate>
            <table width="100%">
                <tr>
                    <td>
                        <asp:Label ID="LabelforTextboxRegistryFlagTypeEmpty" 
                            AssociatedControlID="DropdownListRegistryFlagTypeEmpty" SkinID="DataLabel"
                            runat="server" Text="Registry Flag Type"></asp:Label>  
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                        <asp:Label ID="LabelTextboxRegistryFlagNameEmpty" 
                            AssociatedControlID="TextboxRegistryFlagNameEmpty" SkinID="DataLabel"
                            runat="server" Text="Registry Flag Name **"></asp:Label>  
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                        <asp:Label ID="LabelforTextboxRegistryFlagDescriptionEmpty" 
                            AssociatedControlID="TextboxRegistryFlagDescriptionEmpty" SkinID="DataLabel"
                            runat="server" Text="Registry Flag Description"></asp:Label>  
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:DropdownList ID="DropdownListRegistryFlagTypeEmpty" runat="server" 
                            ToolTip="Select Registry Flag Type" DataSourceID="ObjectDataSourceRegistryFalgType"
                            DataTextField="NAME" DataValueField="ID">
                        </asp:DropdownList>
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                        <asp:Textbox ID="TextboxRegistryFlagNameEmpty" runat="server" 
                            ToolTip="Enter Registry Flag Name"  MaxLength="100"
                            DataTextField="REGISTRY_FLAG_NAME" DataValueField="STD_REGISTRY_FLAG_ID">
                        </asp:Textbox>
                        <br />
                        <asp:RequiredFieldValidator ID="TextboxRegistryFlagEmptyRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TextboxRegistryFlagNameEmpty"                                                                 
                            InitialValue=""
                            ValidationGroup = "RegistryFlagGroup"
                            ErrorMessage="Registry Flag Name is required.">
                        </asp:RequiredFieldValidator> 
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                        <asp:Textbox ID="TextboxRegistryFlagDescriptionEmpty" runat="server"  MaxLength="1000"
                            ToolTip="Enter Registry Flag Description" 
                            DataTextField="REGISTRY_FLAG_DESCRIPTION" DataValueField="STD_REGISTRY_FLAG_ID">
                        </asp:Textbox>
                    </td>
                     <td>
                        <asp:Button ID="ButtonEmptyAddCommand" runat="server" 
                            Text="  Add  " 
                            ToolTip="Add Registry Flag" 
                            CommandName="EMPTYADD" 
                            CausesValidation="true" ValidationGroup = "RegistryFlagGroup" />
                    </td>
                </tr>    
            </table>
             
        </EmptyDataTemplate>
        <Columns>
          <asp:TemplateField HeaderText = "Registry Flag Type" SortExpression="STD_REGISTRY_FLAG_TYPE_ID">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelRegistryFlagType" runat = "server" SkinID="DataLabel" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("STD_REGISTRY_FLAG_TYPE.REGISTRY_FLAG_TYPE")) %>'/>
                </ItemTemplate>
                <FooterTemplate>                                                                      
                    <asp:Label ID = "TextboxRegistryFlagTypeLabel" Text = "Registry Flag Type" SkinID="DataLabel"
                    runat = "server" AssociatedControlID="DropdownListRegistryFlagType"  Font-Size="X-Small"></asp:Label> 
                    <br />   
                     <asp:DropdownList ID="DropdownListRegistryFlagType" runat="server" 
                        ToolTip="Select Registry Flag Type" DataSourceID="ObjectDataSourceRegistryFalgType"
                        DataTextField="NAME" DataValueField="ID">
                    </asp:DropdownList>
               </FooterTemplate> 
           </asp:TemplateField>
           <asp:TemplateField HeaderText = "Registry Flag Name"  SortExpression="REGISTRY_FLAG_NAME">
               <HeaderStyle HorizontalAlign="Center" />
               <ItemTemplate>
                    <asp:Label ID = "LabelRegistryFlag" runat = "server" SkinID="DataLabel" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("REGISTRY_FLAG_NAME")) %>'/>
                </ItemTemplate>
                <FooterTemplate>
                                                                      
                <asp:Label ID = "TextboxRegistryFlagLabel" Text = "Registry Flag Name **" SkinID="DataLabel"
                runat = "server" AssociatedControlID="TextboxRegistryFlagName" Font-Size="X-Small"></asp:Label>  
                <br />  
                <asp:Textbox ID="TextboxRegistryFlagName" runat="server"  MaxLength="100"
                    ToolTip="Enter Registry Flag Name" 
                    DataTextField="REGISTRY_FLAG_NAME" DataValueField="STD_REGISTRY_FLAG_ID">
                </asp:Textbox>
                <br />
                <asp:RequiredFieldValidator ID="TextboxRegistryFlagRequiredValidator" runat="server" 
                    ForeColor="Red" 
                    Display="Dynamic" 
                    EnableClientScript="true"  
                    SetFocusOnError="true"                                                            
                    ControlToValidate="TextboxRegistryFlagName"                                                                 
                    InitialValue=""
                    ValidationGroup = "RegistryFlagGroup"
                    ErrorMessage="Registry Flag Name is required.">
                </asp:RequiredFieldValidator> 
                </FooterTemplate> 
             </asp:TemplateField>
             <asp:TemplateField HeaderText = "Registry Flag Description" SortExpression="REGISTRY_FLAG_DESCRIPTION">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelRegistryFlagDescription" runat = "server" SkinID="DataLabel" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("REGISTRY_FLAG_DESCRIPTION")) %>'/>
                </ItemTemplate>
                <FooterTemplate>
                                                                      
                    <asp:Label ID = "TextboxRegistryFlagDescriptionLabel" Text = "Registry Flag Description" SkinID="DataLabel"
                    runat = "server" AssociatedControlID="TextboxRegistryFlagDescription"  Font-Size="X-Small"></asp:Label> 
                    <br />   
                    <asp:Textbox ID="TextboxRegistryFlagDescription" runat="server"  MaxLength="1000"
                        ToolTip="Enter Registry Flag Description" 
                        DataTextField="REGISTRY_FLAG_NAME" DataValueField="STD_REGISTRY_FLAG_ID">
                    </asp:Textbox>
               </FooterTemplate> 
            </asp:TemplateField>
            <asp:TemplateField HeaderText = "Flag Status"  SortExpression="ACTIVE_FLAG">
                <ItemStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelActiveFlag" runat = "server" SkinID="DataLabel" Text = '<%# Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? "Active" : "Inactive" %>'/>
                </ItemTemplate>
                <FooterTemplate>
                    <br />
                    <asp:Label ID = "LabelActiveFlag" runat = "server" SkinID="DataLabel" Text = "Active" />
              </FooterTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText = "Predefined"  SortExpression="PREDEFINED">
                <ItemStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelPredefined" runat = "server" SkinID="DataLabel" Text = '<%# Convert.ToBoolean(Eval("IsPredefined")) ? "Yes" : "No" %>'/>
                </ItemTemplate>
                <FooterTemplate>
                    <br />
                    <asp:Label ID = "LabelPredefined" runat = "server" SkinID="DataLabel" Text = "No" />
              </FooterTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Action" ShowHeader="True">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <ItemTemplate>
                   <asp:Button ID="ButtonDelete" runat="server"
                        Text="  Delete  "
                        Enabled = '<%# !Convert.ToBoolean(Eval("IsFlagUsed")) && !Convert.ToBoolean(Eval("IsPredefined")) %>' Visible='<%# !Convert.ToBoolean(Eval("IsFlagUsed")) && !Convert.ToBoolean(Eval("IsPredefined")) %>'
                        OnClientClick="return confirm('Are you sure you want to delete this Registry Flag? Click cancel if you do not want to delete.');"
                        ToolTip='<%# string.Format("Delete {0} from Registry Flag list", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"REGISTRY_FLAG_NAME")))) %>' 
                        CommandName="DELETE_FLAG" 
                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_REGISTRY_FLAG_ID"))) %>' 
                        CausesValidation="false"/>
                   <asp:Button ID="ButtonDeactivate" runat="server"
                        Text='<%# Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? " Deactivate " : "  Activate  " %>' 
                        Enabled = '<%# Convert.ToBoolean(Eval("IsFlagUsed")) && !Convert.ToBoolean(Eval("IsPredefined")) %>' Visible='<%# Convert.ToBoolean(Eval("IsFlagUsed")) && !Convert.ToBoolean(Eval("IsPredefined")) %>'
                        ToolTip='<%# string.Format("{0} {1} from Registry Flag list", Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? " Deactivate " : "  Activate  ", DataBinder.Eval(Container.DataItem,"REGISTRY_FLAG_NAME")) %>' 
                        CommandName="UPDATE_FLAG" 
                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_REGISTRY_FLAG_ID"))) %>' 
                        CausesValidation="false"/>
                </ItemTemplate>
                <FooterTemplate>
                   <br />
                   <asp:Button Text="  Add  " ToolTip="Add Registry Flag" CommandName="ADD" CausesValidation="true" runat="server" ID="ButtonAddCommand" 
                   ValidationGroup = "RegistryFlagGroup"  />&nbsp;
                </FooterTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <asp:Label runat="server" ID="LabelFootNote" Text="** indicates required field" CssClass="foot-note" SkinID="DataLabel" ></asp:Label>
    <br />
    </asp:Panel>
    </div>
    <asp:ObjectDataSource ID="ObjectDataSourceRegistryFlags" runat="server" 
        SelectMethod="SelectRegistryFlags" 
        SelectCountMethod="SelectRegistryFlagsCount"
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True"  
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRAdminManager">
        <SelectParameters>
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
            <asp:ControlParameter ControlID="TextBoxKeyWords" Name="keyWords" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="DropDownListStatus" Name="status" PropertyName="SelectedValue" Type="String" />
            <asp:ControlParameter ControlID="DropDownListType" Name="flagType" PropertyName="SelectedValue" Type="String" />
            <asp:ControlParameter ControlID="DropDownListPredefined" Name="predefined" PropertyName="SelectedValue" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>

     <asp:ObjectDataSource ID="ObjectDataSourceRegistryFalgType" runat="server" 
            SelectMethod="SelectLookupList" TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRBaseControlManager" >
        <SelectParameters>
            <asp:Parameter Name="lookupCategory" Type="String" DefaultValue="REGISTRY_FLAG_TYPE" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>

